package edu.uky.ai.lp.logic;

/**
 * Represents the superclass of all logical formulas.
 * 
 * @author Stephen G. Ware
 */
public interface Formula {

	/**
	 * Unify this formula with another formula, adding to a given unifier as
	 * needed to make the two expression the same.  The unifier passed in as
	 * an argument will not be modified; the (possibly extended) unifier is
	 * be returned by this method.
	 * 
	 * @param other the other logical formula to unify with
	 * @param unifier the unifier to extend
	 * @return the new unifier that makes the two formulas the same, or null if they cannot unify
	 */
	public Unifier unify(Formula other, Unifier unifier);
	
	/**
	 * Return a version of this formula with its variables replaced with the
	 * values assigned to them by a unifier.
	 * 
	 * @param unifier the unifier
	 * @return the formula with variables replaced
	 */
	public Formula substitute(Unifier unifier);
}
